% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_data.R
\name{download_data}
\alias{download_data}
\title{Download financial data from Yahoo Finance}
\usage{
download_data(
  symbol,
  from = "1902-01-01",
  to = Sys.Date(),
  file = NULL,
  verbose = TRUE
)
}
\arguments{
\item{symbol}{A \code{character}, the stock's symbol. It must match the identifier on
\url{https://finance.yahoo.com/}.}

\item{from}{A \code{character}, a date in format \code{"YYYY-MM-DD"}, setting the lower
data bound. Must not be earlier than \code{"1902-01-01"} (default).}

\item{to}{A \code{character}, a date in format \code{"YYYY-MM-DD"}, setting the upper
data bound. Default is the current date \code{Sys.date()}.}

\item{file}{Either
\itemize{
\item \code{NULL} (default) to return the data as a \code{data.frame},
\item or a \code{character}, the name of the file where the data is saved as a
\code{.csv}-file.
}}

\item{verbose}{Set to \code{TRUE} to return information about download success.}
}
\value{
A \code{data.frame} if \code{file = NULL}.
}
\description{
This function downloads stock data from \url{https://finance.yahoo.com/}.
}
\details{
The downloaded data has the following columns:
\itemize{
\item \code{Date}: The date.
\item \code{Open}: Opening price.
\item \code{High}: Highest price.
\item \code{Low}: Lowest price.
\item \code{Close}: Close price adjusted for splits.
\item \code{Adj.Close}: Close price adjusted for dividends and splits.
\item \code{Volume}: Trade volume.
}
}
\examples{
### download 21st century DAX data
data <- download_data(symbol = "^GDAXI", from = "2000-01-03")
head(data)

}
