% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eyes.R
\name{eyes}
\alias{eyes}
\alias{eyestr}
\title{Count patients and eyes}
\usage{
eyes(x, id_col = NULL, eye_col = NULL, dropunknown = TRUE, details = FALSE)

eyestr(x, ..., english = "small", caps = FALSE)
}
\arguments{
\item{x}{required. (data frame)}

\item{id_col}{Subject identifying column, passed as (quoted) character
Can also be abbreviated to "id" as per partial matching}

\item{eye_col}{Eye identifying column, passed as (quoted) character.
Can also be abbreviated to "eye" as per partial matching}

\item{dropunknown}{introduces NA for values not recognized by \link{recodeye}}

\item{details}{if TRUE, will add information about which and how many
subjects have only one eye or both included, and provide a list of
subject IDs for each}

\item{...}{passed to \link{eyes}}

\item{english}{Which numbers to be written in plain english:
choose "small" for numbers till 12, "all" (all numbers),
or "none" (or any other string!) for none}

\item{caps}{if TRUE, first number will have capital first letter}
}
\value{
List (of class "eyes" with count of patients and eyes
if "details = TRUE", an list of class "eyes_details" will be returned

\code{eyestr}: Character string - can be directly pasted into reports
}
\description{
Counts number of subjects and right and left eyes. Columns are
guessed.
}
\section{Column guessing}{

\strong{id_col} and \strong{eye_col} arguments overrule the name guessing for
the respective columns (here, cases need to match). Both arguments can be
abbreviated (\emph{id} or \emph{eye}) as per partial argument name matching.

For any below, \strong{cases are always ignored} (column names can be in upper or
lower case, as you please)

\strong{patient ID columns}:
\itemize{
\item First, \code{eyes} is looking for names that contain both strings
"pat" and "id" (the order doesn't matter) -
you can change this with \link{set_eye_strings}
\item Next, it will look for columns that are plainly called "ID"
\item Last, it will search for all names that contain either "pat"
or "id"
}

\strong{eye column}:
\itemize{
\item \code{eyes} primarily looks for columns called either "eye" or "eyes",
(you can change this with \link{set_eye_strings})
and if they are not present, columns containing string "eye"
(e.g., EyeName will be recognized)
}
}

\section{Eye coding}{

The following codes are recognized: (change this with \link{set_eye_strings})
\itemize{
\item integer coding 0:1 and 1:2, right eye being the lower number.
\item right eyes: c("r", "re", "od", "right") and
\item left eyes: c("l", "le", "os", "left") and
\item both eyes: c("b", "both", "ou")
}

If your eye column contains other values, they will be dropped to
NA (dropunknown) or kept (and then only patients will be counted, because
coding remains unclear). Recommend then to recode with \link{recodeye}
}

\section{eyestr}{

eyestr creates a string which can be pasted into reports.
It currently only supports "x eyes of n patient(s)" This is a limitation,
but I guess in the vast majority  of cases will be "correct".
To use for other categories (e.g., "people" or "participants"), use
\code{eyes(...)[1]}
}

\examples{
library(eyedata)
eyes(amd2)

## If you code your eyes with different strings,
## e.g., because you are using a different language,
## you can change this either with `set_eye_strings`
set_eye_strings(right = c("droit", "od"), left = c("gauche", "og"))

## restore defaults with
set_eye_strings()
# Examples for the usage of eyestr
eyestr(amd2)

set.seed(1)
ls_dat <-
  lapply(c(1, 12, 13),
    function(x) data.frame(id = as.character(1:x),
                           eye = sample(c("r", "l"), x, replace = TRUE)))

lapply(ls_dat, eyestr, english = "small")
lapply(ls_dat, eyestr, english = "all")
lapply(ls_dat, eyestr, english = "all", caps = TRUE)
lapply(ls_dat, eyestr, english = "none")
lapply(ls_dat, eyestr, english = "none")
}
\concept{eye core functions}
