% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/selectors.R
\docType{data}
\name{vars}
\alias{vars}
\alias{vars_list}
\alias{indirect}
\alias{indirect_list}
\alias{\%to\%}
\alias{\%to_list\%}
\alias{..}
\alias{..f}
\alias{..p}
\alias{..t}
\title{Get variables/range of variables by name/by pattern.}
\format{
An object of class \code{parameter} of length 1.
}
\usage{
vars(...)

vars_list(...)

indirect(...)

indirect_list(...)

e1 \%to\% e2

e1 \%to_list\% e2

..

..f(...)

..p(...)

..t(...)
}
\arguments{
\item{...}{characters names of variables or criteria/logical functions}

\item{e1}{unquoted name of start variable (e. g. a_1)}

\item{e2}{unquoted name of start variable (e. g. a_5)}
}
\value{
data.frame/list with variables
}
\description{
\itemize{
\item{\code{vars}}{ returns data.frame with all variables by their names or
by criteria (see \link{criteria}). There is no non-standard evaluation in
this function by design so use quotes for names of your variables. This
function is intended to get variables by parameter/criteria. The only
exception with non-standard evaluation is \code{\%to\%}. You can use
\code{\%to\%} inside \code{vars} or independently.}
\item{\code{..p}}{ returns data.frame with all variables which names satisfy
supplied perl-style regular expression. Arguments for this function is quoted
characters. It is a shortcut for \code{vars(perl(pattern))}.}
\item{\code{..f}}{ returns data.frame with all variables which names contain
supplied pattern. Arguments for this function can be unquoted. It is a
shortcut for \code{vars(fixed(pattern))}.}
\item{\code{..t}}{ returns data.frame with variables which names are stored
in the supplied arguments. Expressions in characters in curly brackets are
expanded. See \link{text_expand}.}
\item{\code{..[]}}{ returns data.frame with all variables by their names or 
by criteria (see \link{criteria}).  Names at the top-level can be unquoted 
(non-standard evaluation). For standard evaluation of parameters you can 
surround them by round brackets. You can assign to this expression. If there 
are several names inside square brackets then each element of list/data.frame
from right side will be assigned to appropriate name from left side. You can 
use \code{item1 \%to\% item2} notation to get/create sequence of variables. 
If there are no arguments inside square brackets than from each item of RHS 
will be created separate variable in the parent frame. In this case RHS
should be named list or data.frame. }
\item{\code{..$name}}{ sets/returns object which name is stored in the
variable \code{name}. It is convenient wrapper around 
\link[base]{get}/\link[base]{assign} functions.}
\item{\code{\%to\%}}{ returns range of variables between \code{e1} and 
\code{e2} (similar to SPSS 'to').}
\item{\code{indirect}/\code{indirect_list}}{ are aliases for
\code{vars}/\code{vars_list}.}
}
Functions with word 'list' in name return lists of variables instead of 
dataframes.
}
\keyword{datasets}
