% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aux_fns.R
\name{reMat}
\alias{reMat}
\title{Reconstruct a matrix that was collapsed into a row vector}
\usage{
reMat(vecM, j = NULL)
}
\arguments{
\item{vecM}{Either a single row containing a vectorized matrix, or a matrix
where each row is a column-wise vectorized matrix.}

\item{j}{Row-index of the target matrix to re-construct, if \code{vecM} is a
matrix. If \code{vecM} is a single row vector, then this input can be
neglected.}
}
\value{
A single square matrix
}
\description{
Reconstruct a matrix that was collapsed into a row vector. This function
assumes that the matrix is square (as population projection matrices are).
This function also assumes that the matrix was originally collapsed column-wise.
}
\examples{
A1<- matrix(data=c(0,0.8,0, 0,0,0.7, 5,0,0.2), nrow=3, ncol=3)
A2<- matrix(data=c(0,0.9,0, 0,0,0.5, 4,0,0.3), nrow=3, ncol=3)
A3<- matrix(data=c(0,0.4,0, 0,0,0.6, 6,0,0.25), nrow=3, ncol=3)
A1_remat<- reMat(as.vector(A1))
A_all<- rbind(as.vector(A1), as.vector(A2), as.vector(A3))
A3_remat<- reMat(A_all, j=3)
}
