% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/demographic_fns.R
\name{r_nought}
\alias{r_nought}
\title{R0, the net reproductive output}
\usage{
r_nought(Amat, Fmat)
}
\arguments{
\item{Amat}{The full population projection matrix}

\item{Fmat}{The fertility elements of the population projection matrix.}
}
\value{
The net reproductive output, a single value, is the number of
offspring that an individual is expected to have over their lifespan.
}
\description{
The net reproductive output, R_0, is the expected number of offspring for one
individual across their expected lifespan. It is calculated as the largest
eigenvalue of the matrix product of the fertility matrix and the fundamental
matrix. The fundamental matrix, generally referred to as \strong{N}, contains the
expected number of timesteps that an individual will spend in each age,
stage, or size class of the matrix.
}
\examples{
A1<- matrix(data=c(0,0.8,0, 0,0,0.7, 5,0,0.2), nrow=3, ncol=3)
F1<- matrix(0, nrow=3, ncol=3)
F1[1,3]<- A1[1,3]
#F1 is all zeros, except the upper right corner which matches A1 for adult fertility
R0<- r_nought(A1, F1)
}
