% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/gevrSeqTests.R
\name{gevrSeqTests}
\alias{gevrSeqTests}
\title{Sequential Tests for the GEVr Model}
\usage{
gevrSeqTests(data, nsim = NULL, method = c("ed", "pbscore", "multscore"),
  information = c("expected", "observed"), allowParallel = FALSE,
  numCores = 1)
}
\arguments{
\item{data}{Data should be contain n rows, each a GEVr observation.}

\item{nsim}{If method equals 'pbscore' or 'multscore', the number of bootstrap simulations to use.}

\item{method}{Which test to run: ED test (ed), multiplier (multscore) or parametric bootstrap (pbscore) score test.}

\item{information}{To use expected (default) or observed information in the score tests.}

\item{allowParallel}{If method equals 'pbscore', should the parametric boostrap procedure be run in parallel or not. Defaults to false.}

\item{numCores}{If allowParallel is true, specify the number of cores to use.}
}
\value{
Function returns a matrix containing the test statistics, estimates, and p-value results of the sequential tests.

r Value of r to be tested.

p.values Raw p-values from the individual tests at each value of r.

ForwardStop Transformed p-values according to the ForwardStop stopping rule.

StrongStop Transformed p-values according to the StrongStop stopping rule.

statistic Returned test statistics of each individual test.

est.loc Estimated location parameter for the given r.

est.scale Estimated scale parameter for the given r.

est.shape Estimated shape parameter for the given r.
}
\description{
Sequentially performs the entropy difference (ED) test or the multiplier or parametric bootstrap score tests for the GEVr model.
}
\details{
GEVr data (in matrix x) should be of the form \eqn{x[i,1] > x[i, 2] > \cdots > x[i, r]} for each observation \eqn{i = 1, \ldots, n}.
See function 'pSeqStop' for details on transformed p-values.
}
\examples{
x <- rgevr(200, 5, loc = 0.5, scale = 1, shape = 0.25)
gevrSeqTests(x, method = "ed")
}

