% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/show_any_rounds.R
\name{show_rounds_country}
\alias{show_rounds_country}
\title{Return participating countries for rounds in the European Social Survey}
\usage{
show_rounds_country(rounds, participate = TRUE)
}
\arguments{
\item{rounds}{A numeric vector specifying the rounds from which to return the countries.
Use \code{\link{show_rounds}}for a list of available rounds.}

\item{participate}{A logical that controls whether to show participating countries in that/those
rounds or countries that didn't participate. Set to TRUE by default.}
}
\value{
A character vector with the country names
}
\description{
Return participating countries for rounds in the European Social Survey
}
\examples{

# Return countries that participated in round 2

show_rounds_country(2)

# Return countries that participated in all rounds

show_rounds_country(1:8)

# Return countries that didn't participate in the first three rounds

show_rounds_country(1:3, participate = FALSE)

}
