% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/three_plus_three_selector.R
\name{get_three_plus_three}
\alias{get_three_plus_three}
\title{Get an object to fit the 3+3 model.}
\usage{
get_three_plus_three(num_doses, allow_deescalate = FALSE, ...)
}
\arguments{
\item{num_doses}{Number of doses under investigation.}

\item{allow_deescalate}{TRUE to allow de-escalation, as described by Korn et
al. Default is FALSE.}

\item{...}{Extra args are not currently used.}
}
\value{
an object of type \code{\link{selector_factory}} that can fit the
3+3 model to outcomes.
}
\description{
Get an object to fit the 3+3 model.
}
\examples{
model <- get_three_plus_three(num_doses = 5)

fit1 <- model \%>\% fit('1NNN 2NTN')
fit1 \%>\% recommended_dose()
fit1 \%>\% continue()

fit2 <- model \%>\% fit('1NNN 2NTN 2NNT')
fit2 \%>\% recommended_dose()
fit2 \%>\% continue()

}
\references{
Storer BE. Design and Analysis of Phase I Clinical Trials. Biometrics.
1989;45(3):925-937. doi:10.2307/2531693

Korn EL, Midthune D, Chen TT, Rubinstein LV, Christian MC, Simon RM.
A comparison of two phase I trial designs. Statistics in Medicine.
1994;13(18):1799-1806. doi:10.1002/sim.4780131802
}
