% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/powerset.R
\name{powerset}
\alias{powerset}
\title{Power set of Directed Graphs of size \code{n}}
\usage{
powerset(n, directed = TRUE, force = FALSE, chunk_size = 2e+05)
}
\arguments{
\item{n}{Integer. Number of edges.}

\item{directed}{Logical scalar. Whether to generate the power set of directed
or undirected graphs,}

\item{force}{Logical scalar. When \code{TRUE} it generates the power set for \code{n>5},
otherwise it returns with error.}

\item{chunk_size}{Number of matrices to process at a time. If n = 5, then
stack memory on the computer may overflow if \code{chunk_size} is relatively large.}
}
\description{
Power set of Directed Graphs of size \code{n}
}
\examples{
powerset(2)
powerset(4, directed = FALSE)
}
