% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ergm_blockdiagonal.R
\name{blockdiagonalize}
\alias{blockdiagonalize}
\alias{splitnetwork}
\alias{ergm_blockdiag}
\title{Block-diagonal models using \code{ergm}}
\usage{
blockdiagonalize(x, attrname = "block")

splitnetwork(x, attrname)

ergm_blockdiag(formula, ...)
}
\arguments{
\item{x}{In the case of \code{blockdiagonalize}, a list of networks or matrices.
For \code{splitnetwork} a single network object with a vertex attribute that can
be used to split the data.}

\item{attrname}{Name of the attribute that holds the block ids.}

\item{formula}{An ergm model which networks' will be wrapped with
blockdiagonalize (see details).}

\item{...}{Further arguments passed to the method.}
}
\value{
An object of class \link[ergm:ergm]{ergm::ergm}.
}
\description{
These two functions are used to go back and forth from a pooled ergm vs a
blockdiagonal model, the latter to be fitted using \link[ergm:ergm]{ergm::ergm}.
}
\details{
The function \code{ergm_blockdiag} is a wrapper function that takes the
model's network, stacks the networks into a single block diagonal net, and
calls \link[ergm:ergm]{ergm::ergm} with the option \code{constraints = blockdiag("block")}.

One side effect of this function is that it loads the \code{ergm} package via
\link{requireNamespace}, so after executing the function \code{ergm} the package will
be loaded.
}
\examples{
library(ergm)
data(fivenets)

fivenets2 <- blockdiagonalize(fivenets, attrname = "block") # A network with
ans0 <- ergm(
  fivenets2 ~ edges + nodematch("female"),
  constraints = ~blockdiag("block")
  )
ans1 <- ergmito(fivenets ~ edges + nodematch("female"))

# This is equivalent
ans2 <- ergm_blockdiag(fivenets ~ edges + nodematch("female"))

}
