# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

count_available <- function(i = 0L) {
    .Call(`_ergmito_count_available`, i)
}

count_stats. <- function(X, terms, A) {
    .Call(`_ergmito_count_stats`, X, terms, A)
}

geodesic. <- function(X, force = FALSE) {
    .Call(`_ergmito_geodesic`, X, force)
}

#' Vectorized version of gradient function
#' 
#' @param x Matrix of statistic. `nnets * nstats`.
#' @param params Vector of coefficients.
#' @param weights A list of weights matrices (for `statmat`).
#' @param statmat A list of matrices with statistics for each row in `x`.
#' @noRd
NULL

#' Creates a new `ergmito_ptr`
#' 
#' After calculating the support of the sufficient statistics, the second
#' most computationally expensive task is computing log-likelihoods, 
#' Gradients, and Hessian matrices of ERGMs. This function creates a pointer to an
#' underlying class that is optimized to improve memory allocation and 
#' save computation time when possible.
#' 
#' @details This function is for internal used only. Non-advanced users
#' are not encouraged to use it. See [ergmito_formulae] and [exact_loglik]
#' for user friendly wrappers of this function.
#' @section Recycling computations:
#' 
#' Some components of the likelihood, its gradient, and hessian can be 
#' pre-computed and recycled when needed. For example, it is usually the
#' case that in optimization gradients are computed using a current state
#' of the model's parameter, which implies that the normalizing constant
#' and some other matrix products will be the same between the log-likelihood
#' and the gradient. Because of this, the underlying class `ergmito_ptr`
#' will only re-calculate these shared components if the parameter used
#' changes as well. This saves a significant amount of computation time.
#' 
#' @section Scope of the class methods:
#' 
#' To save space, the class creates pointers to the matrices of sufficient
#' statistics that the model uses. This means that once these objects are
#' deleted the log-likelihood and the gradient functions become invalid
#' from the computational point of view. 
#' 
#' @param target_stats,stats_weights,stats_statmat see [exact_loglik].
#' @export
new_ergmito_ptr <- function(target_stats, stats_weights, stats_statmat) {
    .Call(`_ergmito_new_ergmito_ptr`, target_stats, stats_weights, stats_statmat)
}

#' Vectorized version of log-likelihood function
#' 
#' @param x Matrix of statistic. `nnets * nstats`.
#' @param params Vector of coefficients.
#' @param weights A list of weights matrices (for `statmat`).
#' @param statmat A list of matrices with statistics for each row in `x`.
#' @noRd
exact_loglik. <- function(ptr, params, as_prob = FALSE) {
    .Call(`_ergmito_exact_loglik`, ptr, params, as_prob)
}

#' Vectorized version of log-likelihood function
#' 
#' @param x Matrix of statistic. `nnets * nstats`.
#' @param params Vector of coefficients.
#' @param weights A list of weights matrices (for `statmat`).
#' @param statmat A list of matrices with statistics for each row in `x`.
#' @noRd
exact_gradient. <- function(ptr, params, as_prob = FALSE) {
    .Call(`_ergmito_exact_gradient`, ptr, params, as_prob)
}

#' Vectorized version of gradient function
#' 
#' @param x Matrix of statistic. `nnets * nstats`.
#' @param params Vector of coefficients.
#' @param weights A list of weights matrices (for `statmat`).
#' @param statmat A list of matrices with statistics for each row in `x`.
#' @noRd
exact_hessian. <- function(x, params, stats_weights, stats_statmat) {
    .Call(`_ergmito_exact_hessian`, x, params, stats_weights, stats_statmat)
}

induced_submat. <- function(nets, vs) {
    .Call(`_ergmito_induced_submat`, nets, vs)
}

matrix_to_network. <- function(x, directed, hyper, loops, multiple, bipartite) {
    .Call(`_ergmito_matrix_to_network`, x, directed, hyper, loops, multiple, bipartite)
}

make_sets <- function(n, directed = TRUE) {
    .Call(`_ergmito_make_sets`, n, directed)
}

.powerset <- function(n, force = FALSE, directed = TRUE) {
    .Call(`_ergmito_powerset`, n, force, directed)
}

wrap_powerset <- function(sets, from, to, n) {
    .Call(`_ergmito_wrap_powerset`, sets, from, to, n)
}

