% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InitErgmTerm.R, R/InitWtErgmTerm.R
\name{absdiffcat-ergmTerm}
\alias{absdiffcat-ergmTerm}
\alias{InitErgmTerm.absdiffcat}
\alias{InitWtErgmTerm.absdiffcat}
\title{Categorical absolute difference in nodal attribute}
\usage{
# binary: absdiffcat(attr,
#                 base=NULL,
#                 levels=NULL)

# valued: absdiffcat(attr,
#                 base=NULL,
#                 levels=NULL,
#                 form="sum")
}
\arguments{
\item{attr}{quantitative attribute (see Specifying Vertex attributes and Levels (\code{?nodal_attributes}) for details.)}

\item{base}{deprecated}

\item{levels}{specifies which nonzero difference to include in or exclude from the model. (See Specifying Vertex
attributes and Levels (\code{\link[=nodal_attributes]{?nodal_attributes}}) for details.)}

\item{form}{character how to aggregate tie values in a valued ERGM}
}
\description{
This term adds one statistic for every possible nonzero distinct
value of \code{abs(attr[i]-attr[j])} in the network. The value of each such
statistic is the number of edges in the network with the corresponding
absolute difference.
}
\note{
\pkg{ergm} versions 3.9.4 and earlier used different arguments for this
term. See \code{\link{ergm-options}} for how to invoke the old behaviour.

The argument \code{base} is retained for backwards compatibility and may be
removed in a future version. When both \code{base} and \code{levels} are passed,
\code{levels} overrides \code{base}.
}
\seealso{
\code{\link{ergmTerm}} for index of model terms currently visible to the package.
}
\concept{categorical nodal attribute}
\concept{directed}
\concept{dyad-independent}
\concept{undirected}
