% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InitErgmTerm.R, R/InitWtErgmTerm.R
\name{b1factor-ergmTerm}
\alias{b1factor-ergmTerm}
\alias{InitErgmTerm.b1factor}
\alias{InitWtErgmTerm.b1factor}
\title{Factor attribute effect for the first mode in a bipartite network}
\usage{
# binary: b1factor(attr, base=1, levels=-1)

# valued: b1factor(attr, base=1, levels=-1, form="sum")
}
\arguments{
\item{attr}{quantitative attribute (see Specifying Vertex attributes and Levels (\code{?nodal_attributes}) for details.)}

\item{base}{deprecated}

\item{levels}{this optional argument controls which levels of the attribute
attributes and Levels (\code{\link[=nodal_attributes]{?nodal_attributes}}) for details.)}

\item{form}{character how to aggregate tie values in a valued ERGM}
}
\description{
This term adds multiple network statistics to the model, one for each of (a subset of) the
unique values of the \code{attr} attribute. Each of these statistics
gives the number of times a node with that attribute in the first mode of
the network appears in an edge. The first mode of a bipartite network object
is sometimes known as the "actor" mode.
}
\note{
To include all attribute values is usually not a good idea, because
the sum of all such statistics equals the number of edges and hence a linear
dependency would arise in any model also including \code{edges}. The default,
\code{levels=-1}, is therefore to omit the first (in lexicographic order)
attribute level. To include all levels, pass either \code{levels=TRUE}
(i.e., keep all levels) or \code{levels=NULL} (i.e., do not filter levels).

The argument \code{base} is retained for backwards compatibility and may be
removed in a future version. When both \code{base} and \code{levels} are passed,
\code{levels} overrides \code{base}.

This term can only be used with undirected bipartite networks.
}
\seealso{
\code{\link{ergmTerm}} for index of model terms currently visible to the package.
}
\concept{bipartite}
\concept{categorical nodal attribute}
\concept{dyad-independent}
\concept{frequently-used}
\concept{undirected}
