% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/doThePlotDrugVectors.R
\name{createTanimotoBaseline}
\alias{createTanimotoBaseline}
\title{Creates the plot for all jaccard coefficients amongst the three epilepsy ontologies}
\usage{
createTanimotoBaseline(neuroepso, neuroesso, neuroepi, dneuromaxk)
}
\arguments{
\item{neuroepso}{list of neuro drug names co-occurring with epso}

\item{neuroesso}{list of neuro drug names co-occurring with esso}

\item{neuroepi}{list of neuro drug names co-occurring with epi}

\item{dneuromaxk}{object returned from TopKLists::calculate.maxkS}
}
\value{
jaccardepilepsyplot the ggplot object
}
\description{
Creates the plot for all jaccard coefficients amongst the three epilepsy ontologies
}
\examples{
utils::data(rawDrugBankCoOcEpSO, package="epos")
atchashda <-
  readAtcMapIntoHashMapDrugNamesAtcCodes(
    system.file("extdata", "db-atc.map", package = "epos"), "\\t")
tepso <- genDictListFromRawFreq(rawDrugBankCoOcEpSO)
neuroepso <- filterNeuroDrugs(tepso, atchashda)
utils::data(rawDrugBankCoOcESSO, package="epos")
tesso <- genDictListFromRawFreq(rawDrugBankCoOcESSO)
neuroesso <- filterNeuroDrugs(tesso, atchashda)
utils::data(rawDrugBankCoOcEPILONT, package="epos")
tepi <- genDictListFromRawFreq(rawDrugBankCoOcEPILONT)
neuroepi <- filterNeuroDrugs(tepi, atchashda)
dneuro <-
  data.frame(EpSO = neuroepso[1:10],
             ESSO = neuroesso[1:10],
             EPILONT = neuroepi[1:10])
dneuromaxk <- TopKLists::calculate.maxK(dneuro, 3, 5, 10)
tanimotobaseline <- createTanimotoBaseline(neuroepso, neuroesso, neuroepi, dneuromaxk)
}
