% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coyne2.R
\name{coyne2}
\alias{coyne2}
\title{Edition 2 Gradient-function for Coyne et al's rabies model}
\usage{
coyne2(t, logx, parms)
}
\arguments{
\item{t}{Implicit argument for time}

\item{logx}{A vector with values for the log-states}

\item{parms}{A vector with parameter values for the dynamical system}
}
\value{
A list of gradients for the log system
}
\description{
Edition 2 Gradient-function for Coyne et al's rabies model
}
\examples{
require(deSolve)
times  = seq(0, 50, by=1/520)
paras  = c(gamma = 0.0397, b = 0.836, a = 1.34, sigma = 7.5, 
alpha = 66.36, beta = 33.25, c = 0, rho = 0.8)
start = log(c(S=12.69/2, E1=0.1, E2=0.1, I = 0.1, R = 0.1))
out = as.data.frame(ode(start, times, coyne, paras))
}
