% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/showContents.R
\name{showContents}
\alias{showContents}
\title{Show variable information in data.frame}
\usage{
showContents(data = NULL, functions = c(modes), na.action = "na.pass",
  na.omit.for.variable = TRUE, show.nobs = TRUE)
}
\arguments{
\item{data}{a data.frame whose contents to be shown}

\item{functions}{a vector of functions to be applied to each variable in data.frame. Default added function is \code{mode}, which is almost same functionality as storage.mode except that factor is separated from integer.}

\item{na.action}{a character which specifies missing-data filter function. This is applied to data.frame supplied by data argument. Default is \sQuote{na.pass}.}

\item{na.omit.for.variable}{a logical value specifying whether to apply na.omit for each variable. This option is useful to supply NA free data to each function. When set to TRUE (default), the number of observation may differ for each variable, and it is recommended to check the number of obsevations by show.nobs option.}

\item{show.nobs}{a logical valye specifying whether to add the number of observations for each function as nobs column in result object.}
}
\value{
a data.frame which contains the results of each function.
}
\description{
Show variable information in data.frame.
}
\details{
This function shows contents in data.frame object, and typical use is to list modes of variables in data.frame. In addition to variable mode, a variety of functions can be used such as \code{min}, \code{max} and \code{mean} for summarizing variable information in data.frame.
}
\examples{
dat <- data.frame(a = rnorm(100))
dat <- transform(dat, b = ifelse(a > -2, a, NA))
dat <- transform(dat, c = ifelse(a > 0, "positive", "negative"))
showContents(dat)
showContents(dat, functions=c(modes, storage.mode, min, max, median))
}
\seealso{
\code{\link{countNA}}
}

