% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sparkline-s3.r
\name{sparkline}
\alias{sparkline}
\title{Sparkline}
\usage{
sparkline(df, id.var, ID, yvar, xvar)
}
\arguments{
\item{df}{data.frame from which data for the sparkline is extracted}

\item{id.var}{variable in df with IDs}

\item{ID}{value in id.var on which to extract}

\item{yvar}{name of variable for the y values in the sparkline}

\item{xvar}{optional name of variable for horizontal axis of sparkline plots}
}
\description{
Create sparkline object by extracting from a data frame
}
\details{
Creates an object with info for a single sparkline by extracting 
from a data.frame.  The function works on data.frames with one column of ID variables
         and possibly several columns of other variables.  The main use is 
         as a helper function for building up a \link{sparklineTable}.
}
\examples{
## look at the names in the built-in data set Theoph
names(Theoph) 
## make sparkline object for the concentration over time in subject 2
sl <- sparkline(df= Theoph, id.var = 'Subject', ID = 2, yvar='conc', xvar = 'Time') 
plot(sl)
}
