% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/growingDegDays.R
\name{growingDegDays}
\alias{growingDegDays}
\title{Growing degree days}
\usage{
growingDegDays(meantempstack, baseTemp, tempScale = 1)
}
\arguments{
\item{meantempstack}{rasterStack of mean monthly temperature in deg C * 10}

\item{baseTemp}{base temperature in degrees C.}

\item{tempScale}{integer; scaling factor for the temperature data, see \link{envirem} for 
additional details.}
}
\value{
rasterLayer in degrees C * days.
}
\description{
Growing degree days above some base temperature.
}
\details{
growing degree days = sum of all monthly temps greater than baseTemp, 
multiplied by total number of days
}
\examples{
# Find example rasters
rasterFiles <- list.files(system.file('extdata', package='envirem'), full.names=TRUE)
env <- stack(rasterFiles)

meantemp <- env[[grep('tmean', names(env), value=TRUE)]]
growingDegDays(meantemp, 10, tempScale = 10)
}
\references{
Metzger, M.J., Bunce, R.G.H., Jongman, R.H.G., Sayre, R., Trabucco, A. & Zomer, R. (2013). 
A high-resolution bioclimate map of the world: a unifying framework for global 
biodiversity research and monitoring. \emph{Global Ecology and Biogeography}, 
\strong{22}, 630-638.
}
\author{
Pascal Title
}
