% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/io.R
\name{transform_lines_enc}
\alias{transform_lines_enc}
\title{Transform a text file}
\usage{
transform_lines_enc(path, fun, file_encoding = "UTF-8", ok = TRUE,
  skipNul = FALSE, write_back = TRUE, verbose = interactive())
}
\arguments{
\item{path}{A vector of file paths.}

\item{fun}{A function that returns a character vector.}

\item{file_encoding}{The encoding to assume for the input file.}

\item{ok}{logical.  Is it OK to reach the end of the connection before
    \code{n > 0} lines are read?  If not, an error will be generated.}

\item{skipNul}{logical: should nuls be skipped?}

\item{write_back}{Should the results of the transformation be written back
to the file?}

\item{verbose}{Should the function show a message with a list of changed
files?}
}
\value{
A named logical vector of the same length as \code{path} that indicates
if a file has changed (\code{TRUE} or \code{FALSE}), or if an error occurred (\code{NA})
}
\description{
Reads a file from disk, applies a function on the contents, and optionally
writes the file back if different.
The line ending separator of the input file is used if it can be read and
contains at least one, otherwise \code{\link[=native_eol]{native_eol()}} is used.
}
\seealso{
Other file functions: \code{\link{read_lines_enc}},
  \code{\link{write_lines_enc}}
}
