% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emuR-database.R
\name{load_emuDB}
\alias{load_emuDB}
\title{Load emuDB}
\usage{
load_emuDB(databaseDir, inMemoryCache = FALSE, connection = NULL,
  verbose = TRUE, ...)
}
\arguments{
\item{databaseDir}{directory of the emuDB}

\item{inMemoryCache}{cache the loaded DB in memory}

\item{connection}{pass in DBI connection to SQL database if you want to override the default which is to 
use an SQLite database either in memory (\code{inMemoryCache = TRUE}) or in the emuDB folder. This is intended
for expert use only!}

\item{verbose}{be verbose}

\item{...}{additional parameters}
}
\value{
emuDB handle object
}
\description{
Function loads emuDB into its cached representation and makes it accessible from within the 
current R session by returning a emuDBhandle object
}
\details{
In order to access an emuDB from R it is necessary to load the annotation and configuration 
files to an emuR internal database format. The function expects a emuDB file structure in directory 
\code{databaseDir}. The emuDB configuration file is loaded first. On success the function iterates 
through session and bundle directories and loads found annotation files. The parameter \code{inMemoryCache} 
determines where the internal database is stored: If \code{FALSE} a database cache file in \code{databaseDir} 
is used. When the database is loaded for the first time the function will create a new cache file and store 
the data to it. On subsequent loading of the same database the cache is only updated if files have changed, 
therefore the loading is then much faster. For this to work the user needs write permissions to 
\code{databaseDir} and the cache file. The database is loaded into a volatile in-memory database if 
\code{inMemoryCache} is set to \code{TRUE}.
}
\examples{
\dontrun{
## Load database ae in directory /homes/mylogin/EMUnew/ae 
## assuming an existing emuDB structure in this directory

ae = load_emuDB("/homes/mylogin/EMU/ae")

## Load database ae from demo data

# create demo data in temporary directory
create_emuRdemoData(dir = tempdir())
# build base path to demo emuDB
demoDatabaseDir = file.path(tempdir(), "emuR_demoData", "ae_emuDB")

# load demo emuDB
ae = load_emuDB(demoDatabaseDir)

}
}
\keyword{DBconfig}
\keyword{database}
\keyword{emuDB}
