#' Database of RMU for marine turtles
#' @title Database of RMU for marine turtles
#' @author Marc Girondot \email{marc.girondot@@universite-paris-saclay.fr}
#' @author Maria Sousa Martins \email{maria.esmartins@@gmail.com}
#' @docType data
#' @name DatabaseNestingArea
#' @encoding UTF-8
#' @description Database of RMU for marine turtles
#' @references Wallace, B. P., DiMatteo, A. D., Hurley, B. J., Finkbeiner, 
#'             E. M., Bolten, A. B., Chaloupka, M. Y., Hutchinson, B. J., 
#'             Abreu-Grobois, F. A., Amorocho, D., Bjorndal, K. A., Bourjea, J., 
#'             Bowen, B. W., Duenas, R. B., Casale, P., Choudhury, B. C., Costa, A., 
#'             Dutton, P. H., Fallabrino, A., Girard, A., Girondot, M., 
#'             Godfrey, M. H., Hamann, M., Lopez-Mendilaharsu, M., Marcovaldi, 
#'             M. A., Mortimer, J. A., Musick, J. A., Nel, R., Seminoff, J. A., 
#'             Troeng, S., Witherington, B. & Mast, R. B. 2010. Regional management 
#'             units for marine turtles: a novel framework for prioritizing conservation 
#'             and research across multiple scales. Plos One, 5, e15465.
#' @keywords datasets
#' @usage DatabaseNestingArea
#' @examples
#' \dontrun{
#' library(embryogrowth)
#' data(DatabaseNestingArea)
#' }
#' @format A dataframe with raw data.
NULL
