% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resultNest_4p_trigo.R
\docType{data}
\encoding{UTF-8}
\name{resultNest_4p_trigo}
\alias{resultNest_4p_trigo}
\title{Result of the fit using the nest database using trigonometric function}
\format{A list with fitted information about data(nest)}
\usage{
resultNest_4p_trigo
}
\description{
Fit using the nest database using trigonometric function
}
\details{
Result of the fit using the nest database using trigonometric function
}
\examples{
\dontrun{
library(embryogrowth)
data(nest)
formated <- FormatNests(nest)
x <- ChangeSSM(temperatures = (200:350)/10,
               parameters = resultNest_4p_SSM4p$par,
               initial.parameters = structure(c(3, 20, 40, 32), 
                         .Names = c("Max", "LengthB", "LengthE", "Peak")), 
               control=list(maxit=1000))
pfixed <- c(rK=2.093313)
resultNest_4p_trigo <- searchR(parameters=x$par, fixed.parameters=pfixed, 
                         temperatures=formated, derivate=dydt.Gompertz, M0=1.7, 
                         test=c(Mean=39.33, SD=1.92))
plotR(resultNest_4p_trigo, ylim=c(0, 3))
plotR(resultNest_4p_trigo, ylim=c(0, 3), ylimH = c(0, 0.9), show.hist=TRUE)
compare_AIC(SSM=resultNest_4p_SSM4p, trigonometric=resultNest_4p_trigo)
}
}
\references{
Girondot, M., & Kaska, Y. (2014). A model to predict 
            the thermal reaction norm for the embryo growth rate 
            from field data. Journal of Thermal Biology, 45, 96-102. 
            doi: 10.1016/j.jtherbio.2014.08.005
}
\author{
Marc Girondot \email{marc.girondot@u-psud.fr}
}
\keyword{datasets}
