% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eem_metrics.R
\name{eem_peaks}
\alias{eem_peaks}
\title{Extract fluorescence peaks}
\usage{
eem_peaks(eem, ex, em, verbose = TRUE)
}
\arguments{
\item{eem}{An object of class \code{eemlist}.}

\item{ex}{A numeric vector with excitation wavelengths.}

\item{em}{A numeric vector with emission wavelengths.}

\item{verbose}{Logical determining if additional messages should be printed.}
}
\value{
An object of class \code{eemlist}.

A data frame containing excitation and emission peak values. See
  details for more information.
}
\description{
Extract fluorescence peaks
}
\section{Interpolation}{


  Different excitation and emission wavelengths are often used to measure
  EEMs. Hence, it is possible to have mismatchs between measured wavelengths
  and wavelengths used to calculate specific metrics. In these circumstances,
  EEMs are interpolated using the \code{\link{interp2}} function from the
  \code{parcma} library. A message warning the user will be prompted if data
  interpolation is performed.
}

\examples{
file <- system.file("extdata/cary/scans_day_1/", "sample1.csv", package = "eemR")
eem <- eem_read(file, import_function = "cary")

eem_peaks(eem, ex = c(250, 350), em = c(300, 400))
}
\seealso{
\link[pracma]{interp2}
}
