% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eem_correction.R
\name{eem_raman_normalisation}
\alias{eem_raman_normalisation}
\title{Fluorescence Intensity Calibration Using the Raman Scatter Peak of Water}
\usage{
eem_raman_normalisation(eem, blank)
}
\arguments{
\item{eem}{Either an object of class \code{eem} or \code{eemlist}.}

\item{blank}{Either an object of class \code{eem} or a list of \code{eem}.}
}
\value{
Either an object of class \code{eem} or \code{eemlist}.

An object of class \code{eem} containing: \itemize{ \item sample The
  file name of the eem. \item x A matrix with fluorescence values. \item em
  Emission vector of wavelengths. \item ex Excitation vector of wavelengths.
  }
}
\description{
Normalize fluorescence intensities to the standard scale of
  Raman Units (R.U).
}
\details{
The normalization procedure consists in dividing all fluorescence
  intensities by the area (integral) of the Raman peak. The peak is located
  at excitation of 350 nm. (ex = 370) betwen 371 nm. and 428 nm in emission
  (371 <= em <= 428).
}
\examples{
# Open the fluorescence eem
file <- system.file("extdata/cary/eem/", "sample1.csv", package = "eemR")
eem <- eem_read(file)

plot(eem)

# Open the blank eem
file <- system.file("extdata/cary/", "nano.csv", package = "eemR")
blank <- eem_read(file)

# Do the normalisation
eem <- eem_raman_normalisation(eem, blank)

plot(eem)
}
\references{
Lawaetz, A. J., & Stedmon, C. A. (2009). Fluorescence Intensity Calibration
Using the Raman Scatter Peak of Water. Applied Spectroscopy, 63(8), 936-940.

\url{http://doi.org/10.1366/000370209788964548}

Murphy, K. R., Stedmon, C. a., Graeber, D., & Bro, R. (2013). Fluorescence
spectroscopy and multi-way techniques. PARAFAC. Analytical Methods, 5(23),
6557.

\url{http://xlink.rsc.org/?DOI=c3ay41160e}
}

