% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statTableList.R
\name{statTableList}
\alias{statTableList}
\title{Table list of statistical tables}
\usage{
statTableList(
  api_key,
  format = c("xml", "json"),
  lang = c("kr", "en"),
  count = 1000
)
}
\arguments{
\item{api_key}{A string specifying ECOS API key. Need not be specified if
the key was stored as an environment variable via \code{\link{setKey}} or
.Renviron.}

\item{format}{A string specifying the file format to process - xml, json}

\item{lang}{A string specifying the language of result value - kr (Korean),
en (English)}

\item{count}{An integer specifying the number of requests}
}
\value{
A data.frame object containing queried information
}
\description{
Table list of statistical tables
}
\details{
\preformatted{
## Example
statTableList(lang = "en", count = 100)
}
}
