% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grid.R
\name{radius_axis}
\alias{radius_axis}
\alias{e_radius_axis}
\alias{e_radius_axis_}
\title{Radius axis}
\usage{
e_radius_axis(e, serie, show = TRUE, ...)

e_radius_axis_(e, serie = NULL, show = TRUE, ...)
}
\arguments{
\item{e}{An \code{echarts4r} object as returned by \code{\link{e_charts}}.}

\item{serie}{Serie to use as axis labels.}

\item{show}{Whether to display the axis.}

\item{...}{Any other option to pass, check See Also section.}
}
\description{
Customise radius axis.
}
\examples{
df <- data.frame(x = LETTERS[1:10], y = seq(1, 20, by = 2))

df \%>\% 
  e_charts(x) \%>\% 
  e_polar() \%>\% 
  e_angle_axis() \%>\% 
  e_radius_axis(x) \%>\% 
  e_bar(y, coord.system = "polar") 

}
\seealso{
\href{https://ecomfe.github.io/echarts-doc/public/en/option.html#radiusAxis}{Additional arguments}
}
