% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hydro_util.r
\name{time_to_peak}
\alias{time_to_peak}
\title{Time between the peak rainfall and the peak discharge}
\usage{
time_to_peak(rain, qsim, units = "hour")
}
\arguments{
\item{rain}{Time series of rainfall.}

\item{qsim}{Time series of discharges.}

\item{units}{Units in which to return the value}
}
\description{
Return the lag, in hours, between the peak in the rainfall record and that of the discharge
}
\examples{

require(dynatopmodel)

data(brompton)

with(brompton$storm.run, time_to_peak(rain, qsim))
}
\seealso{
time_at_peak
}
\author{
Peter Metcalfe
}
