.ls.objects <-
function (pos = 1, pattern, order.by,
						 decreasing=FALSE, head=FALSE, n=5) {
	napply <- function(names, fn) sapply(names, function(x)
		fn(get(x, pos = pos)))
	names <- ls(pos = pos, pattern = pattern)
	obj.class <- napply(names, function(x) as.character(class(x))[1])
	obj.mode <- napply(names, mode)
	obj.type <- ifelse(is.na(obj.class), obj.mode, obj.class)
	obj.size <- round(napply(names, object.size)/2^20, 1)  # size in Mb 
	obj.dim <- t(napply(names, function(x)
		as.numeric(dim(x))[1:2]))
	vec <- is.na(obj.dim)[, 1] & (obj.type != "function")
	obj.dim[vec, 1] <- napply(names, length)[vec]
	out <- data.frame(obj.type, obj.size, obj.dim)
	names(out) <- c("Type", "Size", "Rows", "Columns")
	if (!missing(order.by))
		out <- out[order(out[[order.by]], decreasing=decreasing), ]
	if (head)
		out <- head(out, n)
	out
}
.Random.seed <-
c(403L, 385L, 22213196L, -1431281411L, 152356135L, 1105629984L, 
843634231L, -1642894100L, -1661075150L, 1672534697L, 405078312L, 
-893866933L, 32248420L, -559585373L, 678813896L, 579567832L, 
-1831926281L, 724481033L, 1126260322L, -1184265106L, 131504686L, 
1802592654L, 928651158L, 585898992L, -531868308L, 437827098L, 
-550093802L, 529368214L, -955930250L, -330061101L, -521921294L, 
-2048362644L, -1125252190L, -1068765952L, -1801746022L, 748683917L, 
1661041075L, 1629975590L, 507563056L, 867804966L, 1844580195L, 
2129874799L, -999763890L, 615921601L, -1857345184L, 1673603906L, 
-1358567068L, -1702684800L, 1753810054L, 302592333L, 1974851379L, 
-1365478516L, 1549527442L, 1145374959L, -613570049L, 2056560860L, 
1762894428L, -1807455349L, -1271390865L, -848980392L, -174558954L, 
-262749796L, 1643744904L, -110141180L, -367324617L, -2143471985L, 
1449422311L, 1113382173L, 413737713L, 119638330L, -656198516L, 
-441965532L, 750215469L, 1416333180L, -1152860972L, 241879230L, 
894620471L, -978713152L, 454501455L, -1783719577L, 649605576L, 
2135145463L, 1545803001L, 1422220497L, 283376261L, 690369827L, 
1651405487L, -1323495294L, -1473275667L, 52929600L, 82965907L, 
-1877647876L, 435871757L, -240520594L, -1293835987L, 2139149205L, 
-1697140997L, 1053062925L, 1948634200L, -1245157830L, 1382073452L, 
183543525L, -1703666369L, -1428247812L, 1708355807L, -1108835823L, 
-2066997053L, 410833487L, -1203434953L, -792288909L, 1996213346L, 
231468028L, -907867297L, -609787886L, 884213789L, 949857462L, 
-196074235L, 821015084L, -850960212L, -9077718L, -1563032039L, 
1052490410L, 597781509L, -2076960149L, 1085301920L, 172012468L, 
-1616215718L, -970370482L, -1507229564L, 1026683511L, -2071204912L, 
1797585019L, -1870205551L, -1430135999L, -350426237L, 2007962242L, 
1743662850L, 988972717L, -1203651658L, -1215979293L, -394917640L, 
-644735163L, 1597727844L, 2140504435L, -243030786L, 74262519L, 
1433918591L, 1563592818L, 249851100L, -137288969L, -505562408L, 
-988384621L, 429078411L, -338055677L, 571607017L, -634806409L, 
-1040907549L, -684592542L, -9523476L, 110204487L, -402214193L, 
1226329762L, -1789720560L, -1108293405L, 1584113463L, -1810074475L, 
2002552978L, -1779424591L, 642115152L, 308931020L, 795033650L, 
1707468654L, 1455879893L, -664367788L, 935350906L, 1954286796L, 
-2038347603L, 1275706597L, 1808250337L, -995652055L, -1500190354L, 
-1146573360L, -1754382358L, -1867416765L, 1469828824L, 198811170L, 
1597760683L, 1994565133L, -431412378L, -1941569412L, 1450562231L, 
294626303L, 916510644L, 978810357L, 1048245314L, -786132300L, 
-1571673636L, 385907388L, 323429258L, 1225499121L, -112486468L, 
-2028057243L, 538484543L, 1118926512L, -245858250L, 662132450L, 
-12931088L, -388884488L, 380273151L, -2085599251L, 154204574L, 
-1941486626L, -1293875787L, 42932204L, 2083325731L, -1446994348L, 
798170742L, 1225788634L, 1032738862L, -1149480837L, -1345124565L, 
90492055L, -159306304L, -433087271L, 1727706877L, -742467778L, 
160529724L, -182465462L, 33220502L, -148693432L, 915902358L, 
-943633625L, -830727397L, 720436422L, 1904733864L, -206855051L, 
1229903682L, -1591605764L, -153693264L, 735617970L, -477859597L, 
-1667400342L, -1171040344L, 1993970336L, 1303953130L, -1995124426L, 
1253167024L, 865553745L, -848913084L, -569605553L, -51772403L, 
449704986L, -917568482L, -1766686456L, -1821977974L, 1592500733L, 
-192516897L, 1906820937L, -1450664473L, 574585726L, -2015781930L, 
1685838052L, -1903916375L, -2146913892L, 1256197906L, -1632814847L, 
-1309034981L, -419786140L, -544506473L, 1873093306L, -1983962767L, 
-796938824L, 1495106766L, -401873163L, -1577144605L, -2015543863L, 
494667091L, 1874786588L, 1880741910L, -219224816L, 1475334378L, 
1934225597L, 979477630L, 1965803230L, -1973403152L, 803865828L, 
1246629480L, 557785671L, -1858859296L, -14263761L, 1676368862L, 
-824851809L, -1079392350L, -798725436L, 549206714L, -236138850L, 
1045647583L, 699293878L, -1749067718L, -1979236700L, -1271212776L, 
481495730L, 371079101L, -1871903187L, -1452121414L, -1033158953L, 
-1189058295L, -736530587L, 1204665355L, 2126942713L, 275660223L, 
883792648L, -1909618651L, -1551817500L, 1576187225L, 720593190L, 
1436857579L, 1678187066L, 308026027L, 8179354L, -472691292L, 
2138531761L, 855253952L, 1373328047L, 1764998576L, 1858622450L, 
1846327263L, 1485786871L, 9075248L, -37611463L, 108513733L, 638610340L, 
-1595220881L, -899816307L, 1483021038L, -949850773L, 584576681L, 
-1167083978L, 1001423489L, -2061685245L, 1630754098L, 1697575897L, 
-639289659L, 1063873448L, 1957608745L, 1145062152L, -664563098L, 
1183026072L, -1465357594L, 1103887462L, 428826877L, 2129662044L, 
-1528421821L, -242274733L, 1494785516L, -1035996950L, -948119846L, 
368921480L, 535712520L, -1688971788L, -2032662135L, -5124114L, 
1492177175L, 1602433993L, 1485488311L, -768765919L, -1803246076L, 
-947416101L, 511015786L, 1468310999L, -1252687067L, -18409543L, 
-1130048886L, 1473605982L, 764918296L, 2006700473L, 842088088L, 
1432369160L, -1935604131L, -1131961211L, -1060847281L, -26594795L, 
-1264616829L, 701956915L, 306675881L, 200514172L, 1032465620L, 
-1886112973L, -843682093L, -1229125958L, -83098389L, -211532703L, 
261387251L, 418212668L, 1176712844L, 1110724405L, 826546962L, 
1933167819L, -77401594L, -2077081391L, 165237418L, -895558915L, 
789926183L, -1334431538L, -447256059L, 1660279735L, 1144327099L, 
-245774440L, 1925142034L, -1539841561L, -363503301L, -1576316890L, 
558244468L, 1083115117L, 1892261087L, 2006433731L, -905751632L, 
1958811363L, 189495590L, -482294304L, 1367973061L, -1470253722L, 
-347083482L, -212698104L, -796783214L, 2113066096L, 1528657008L, 
807457678L, -1002799021L, -781115527L, -586459652L, -798652756L, 
438829427L, -1843690083L, -468438309L, 59114398L, -1252509064L, 
-503982653L, 1581348112L, 1226787724L, -2128304029L, -1039376332L, 
-1721957154L, -1843620659L, 710746372L, -612831243L, 512480653L, 
-1359593472L, 611370177L, 1423151479L, -1747734480L, -31529703L, 
-1016779090L, -353568137L, -309805481L, -47110459L, 276537590L, 
1148490119L, -2107253001L, 1093466240L, 1172259872L, 791152683L, 
2064254506L, 1391025194L, -470801034L, -1377517555L, -250735012L, 
-1205778380L, 1747218660L, 778057187L, -1613305437L, 1995316898L, 
-1705337896L, 923547631L, -369124101L, -62884680L, 1907231828L, 
1328292308L, -1480794812L, 1711817264L, -89270720L, -1492935615L, 
712702435L, 1647295896L, -1502014818L, -935353973L, 1311482020L, 
1024136690L, 935135830L, -135611379L, -2122581735L, -1081879938L, 
20123691L, -1948068446L, -1108595252L, -2016959660L, -1322390112L, 
2086745353L, 949606287L, 1360133212L, -1719336427L, -1784155084L, 
2110000636L, 510171320L, -1003867501L, -119252557L, -1069839874L, 
869541756L, -424001729L, 916439978L, 1103588759L, 1843868366L, 
-886423975L, 661738123L, 1640429538L, 1169905488L, 1389248550L, 
-613405777L, -1685743093L, 1464566032L, 959425052L, 699845236L, 
-417510864L, 547361635L, 1277177088L, -1788107740L, -1186483807L, 
-1398277751L, 340408039L, -1049993842L, 1756105952L, -987886675L, 
-1397319852L, 1988356950L, 245908909L, -2006061354L, -2047330441L, 
-10370990L, -1587888999L, -1908683670L, 2120376022L, -1928374827L, 
458852119L, 423120826L, 173949029L, -1220854188L, -1076990091L, 
-1219025356L, 796550086L, -1302384513L, -1545645801L, 136745696L, 
-420749839L, -1433975352L, 1391841968L, 705226581L, 670585049L, 
1877982617L, 1361322909L, -898466671L, 490930230L, 84701026L, 
-287590211L, 790778165L, 713775714L, -2104990709L, -1161074111L, 
1859325955L, 71346243L, -247237078L, -1474605299L, 116374290L, 
-1870429132L, -1167469144L, -1084506283L, -498218895L, 888301855L, 
-1062389740L, -898105571L, -443000195L, -297665162L, -1259119114L, 
-507991649L, -641824079L, 450907219L, 193622890L, 763545820L, 
1935697847L, -1282884548L, 250023726L, 544403042L, -1576892342L, 
-689506941L, -1685118191L, -1908162346L, -1296229166L, 2002723864L, 
1917959405L, -830956517L, -943379981L, 2110790769L, -860025663L, 
641382670L, -41544612L, 1081978080L, -1635171325L, 1281326279L, 
94947981L, 580412485L, -1788902730L, 1597056819L, 1194263927L, 
-1478130998L, 420553347L, 289700492L, -1621396128L, -1975729961L, 
-1006522446L, 1576098587L, -1585172015L, -1331114995L, -510432048L, 
707191859L, 533069552L, -417213966L, -70546656L)
.show.message <-
TRUE
