% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tslist.R
\name{tslist}
\alias{tslist}
\title{Coerce matrices or data frames to a list of time series}
\usage{
tslist(series)
}
\arguments{
\item{series}{A matrix or data frame where each row is a time series.}
}
\value{
A list of time series.
}
\description{
Change a matrix or data frame to a list of univariate time series
}
\details{
Almost all functions in \pkg{dtwclust} work internally with lists of time series. If you want to
avoid constant coercion, create a list of time series once by calling this function.

For matrices and data frames, each \strong{row} is considered as one time series. A list input is
simply passed through.
}
\note{
The function assumes that indexing the matrix/data.frame with \code{series[i, ]} will return a numeric
vector.
}
