% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.dtw.R
\name{dtwPlot}
\alias{dtwPlot}
\alias{plot.dtw}
\alias{dtwPlotAlignment}
\title{Plotting of dynamic time warp results}
\usage{
\method{plot}{dtw}(x, type = "alignment", ...)

dtwPlotAlignment(d, xlab = "Query index", ylab = "Reference index",
  plot.type = "l", ...)
}
\arguments{
\item{x, d}{\code{dtw} object, usually result of call to \code{\link[=dtw]{dtw()}}}

\item{type}{general style for the plot, see below}

\item{...}{additional arguments, passed to plotting functions}

\item{xlab}{label for the query axis}

\item{ylab}{label for the reference axis}

\item{plot.type}{type of line to be drawn, used as the \code{type} argument
in the underlying \code{plot} call}
}
\description{
Methods for plotting dynamic time warp alignment objects returned by
\code{\link[=dtw]{dtw()}}.
}
\details{
\code{dtwPlot} displays alignment contained in \code{dtw} objects.

Various plotting styles are available, passing strings to the \code{type}
argument (may be abbreviated):
\itemize{
\item \code{alignment} plots the warping curve in \code{d};
\item \code{twoway} plots a point-by-point comparison, with matching lines; see \code{\link[=dtwPlotTwoWay]{dtwPlotTwoWay()}};
\item \code{threeway} vis-a-vis inspection of the timeseries and their warping curve; see \code{\link[=dtwPlotThreeWay]{dtwPlotThreeWay()}};
\item \code{density} displays the cumulative cost landscape with the warping path overimposed; see \code{\link[=dtwPlotDensity]{dtwPlotDensity()}}
}

Additional parameters are passed to the plotting functions: use with
care.
}
\section{Warning}{
 These functions are incompatible with mechanisms for
arranging plots on a device: \code{par(mfrow)}, \code{layout} and
\code{split.screen}.
}

\examples{

## Same example as in dtw

idx<-seq(0,6.28,len=100);
query<-sin(idx)+runif(100)/10;
reference<-cos(idx)

alignment<-dtw(query,reference,keep=TRUE);

# A sample of the plot styles. See individual plotting functions for details

plot(alignment, type="alignment",
  main="DTW sine/cosine: simple alignment plot")
  
plot(alignment, type="twoway",
  main="DTW sine/cosine: dtwPlotTwoWay")

plot(alignment, type="threeway",
  main="DTW sine/cosine: dtwPlotThreeWay")
  
plot(alignment, type="density",
  main="DTW sine/cosine: dtwPlotDensity")
  
}
\seealso{
\code{\link[=dtwPlotTwoWay]{dtwPlotTwoWay()}}, \code{\link[=dtwPlotThreeWay]{dtwPlotThreeWay()}} and  \code{\link[=dtwPlotDensity]{dtwPlotDensity()}} for details
on the respective plotting styles.

Other plot: \code{\link{dtwPlotDensity}},
  \code{\link{dtwPlotThreeWay}},
  \code{\link{dtwPlotTwoWay}}
}
\author{
Toni Giorgino
}
\concept{plot}
\keyword{hplot}
\keyword{ts}
