% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dayte-time.R
\name{dtt_dayte_time}
\alias{dtt_dayte_time}
\alias{dtt_dayte_time.Date}
\alias{dtt_dayte_time.POSIXct}
\title{Dayte Time}
\usage{
dtt_dayte_time(x, ...)

\method{dtt_dayte_time}{Date}(x, start = 1L, tz = dtt_default_tz(), ...)

\method{dtt_dayte_time}{POSIXct}(x, start = 1L, ...)
}
\arguments{
\item{x}{A date/time vector.}

\item{...}{Unused.}

\item{start}{An integer scalar of the starting month or a Date scalar of the starting date.}

\item{tz}{A string of the time zone.}
}
\value{
A Date vector with the year set to year.

A POSIXct vector of the dayte times.
}
\description{
Dayte Time
}
\section{Methods (by class)}{
\itemize{
\item \code{dtt_dayte_time(Date)}: Dayte Time a Date vector

\item \code{dtt_dayte_time(POSIXct)}: Dayte Time a POSIXct vector

}}
\examples{
dtt_dayte_time(as.POSIXct(c("2001-01-01 12:13:14", "2015-12-13"), tz = "Etc/GMT+10"))
}
\seealso{
Other dayte: 
\code{\link{dtt_dayte}()},
\code{\link{dtt_daytt}()}
}
\concept{dayte}
