% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dsrwon.R
\name{dsrwon}
\alias{dsrwon}
\title{Combination of two mass functions}
\usage{
dsrwon(x, y, relnb = NULL)
}
\arguments{
\item{x}{A  bca mass function (see \code{\link{bca}}).}

\item{y}{A  bca mass function (see bca).}

\item{relnb}{Identification number of the relation. Can be omitted.}
}
\value{
A list of class bcaspec with these two components added: \itemize{
  \item I12 Intersection table of subsets.
  \item Sort_order Sort order of subsets.
  }
}
\description{
The unnormalized Dempster's rule is used to combine two mass functions \code{mx} and \code{my} defined  on the same frame of discernment and represented by their respective basic chance assignments \code{x}  and \code{y}. Dempster's rule of combination is applied. The normalization is not done, leaving the choice  to the user to normalize the results or not (for the normalization operation, see \code{\link{nzdsr}}).
}
\details{
The two bca's \code{x} and \code{y} must be defined on the same frame of discernment for the combination to take place. The relation number of the x input is given to the output result.
}
\examples{
x1 <- bca(f=matrix(c(0,1,1,1,1,0,1,1,1),nrow=3, 
byrow = TRUE), m=c(0.2,0.5, 0.3), 
cnames =c("a", "b", "c"),  
infovarnames = "x", varnb=1)
x2 <- bca(f=matrix(c(1,0,0,1,1,1),nrow=2, 
byrow = TRUE), m=c(0.6, 0.4),  
cnames = c("a", "b", "c"),  
infovarnames = "x", varnb = 1)
dsrwon(x1,x2)
}
\references{
Shafer, G., (1976). A Mathematical Theory of Evidence. Princeton University Press, Princeton, New Jersey, pp. 57-61: Dempster's rule of combination.
}
\author{
Claude Boivin, Stat.ASSQ
}
