% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/count_mu.R
\name{count_mu_gcdg}
\alias{count_mu_gcdg}
\title{Median of GCDG references}
\usage{
count_mu_gcdg(t)
}
\arguments{
\item{t}{Decimal age, numeric vector}
}
\value{
A vector of length \code{length(t)} with the median of the GCDG references.
}
\description{
Returns the age-interpolated median of the GCDG references (Weber
et al, 2019). The working range is 0-4 years. This function is used
to set prior mean under keys \code{"gcdg"} and \code{"gsed1912"}.
}
\note{
Internal function. Called by \code{dscore()}
}
\examples{
dscore:::count_mu_gcdg(0:2)
}
