% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dsa.R
\name{dsa}
\alias{dsa}
\title{Seasonally Adjust Daily Time Series}
\usage{
dsa(series, span.start = NA, model = NULL, Log = FALSE, Diff = 0,
  automodel = "reduced", ic = "bic", fourier_number = NA,
  s.window1 = 151, s.window2 = 51, s.window3 = 15, t.window1 = NULL,
  t.window2 = NULL, t.window3 = NULL, cval = 7, robust1 = TRUE,
  robust2 = TRUE, robust3 = TRUE, regressor = NULL,
  forecast_regressor = NULL, reg.create = c("Easter", "Ascension"),
  reg.dummy = NULL, outlier.types = c("AO", "LS", "TC"), modelspan = NULL,
  trend_month = 3, outer3 = NULL, inner3 = NULL, h = 365,
  reiterate3 = NULL, scaler = 1e+07, progressBar = TRUE)
}
\arguments{
\item{series}{Input time series}

\item{span.start}{Define when seasonal adjustment should begin}

\item{model}{ARIMA order of non-seasonal part}

\item{Log}{Boolean. Should multiplicate or additive model be used?}

\item{Diff}{Number of differences taken before STL is run.}

\item{automodel}{Set of models to be considered for automatic model detection. Either "full" or "reduced" set of fourier regressors included.}

\item{ic}{Information criterion that is used for automodelling. One of "bic", "aic" or "aicc"}

\item{fourier_number}{Number of trigometric regressors to model annual and monthly seasonality}

\item{s.window1}{STL parameter s.window for the day of the week effect}

\item{s.window2}{STL parameter s.window for the day of the month effect}

\item{s.window3}{STL parameter s.window for the day of the year effect}

\item{t.window1}{STL parameter t.window for the day of the week effect}

\item{t.window2}{STL parameter t.window for the day of the month effect}

\item{t.window3}{STL parameter t.window for the day of the year effect}

\item{cval}{Critical value for outlier adjustment}

\item{robust1}{Boolean. Should robust STL be used for the day of the week effect}

\item{robust2}{Boolean. Should robust STL be used for the day of the month effect}

\item{robust3}{Boolean. Should robust STL be used for the day of the year effect}

\item{regressor}{Pre-specified regressors}

\item{forecast_regressor}{Pre-specified regressors to be used for forecasting}

\item{reg.create}{Names of Holidays for which regressors will be created}

\item{reg.dummy}{If specified dummy variables of specified length are created and used as regressors}

\item{outlier.types}{The following are possible: "LS", "TC", "AO", "IO"}

\item{modelspan}{Last x years used for regARIMA modelling.}

\item{trend_month}{Length of support period for trend estimation}

\item{outer3}{Number of iterations of outer loop in STL for day of the year effect}

\item{inner3}{Number of iterations of inner loop in STL for day of the year effect}

\item{h}{Forecast horizon in number of days}

\item{reiterate3}{Number of total iterations of STL for the day of the year effect}

\item{scaler}{for additive model, if max(abs(series)) > 1e5, scale series}

\item{progressBar}{Should a progress bar be displayed?}
}
\description{
Seasonally adjust daily time series using the dsa approach
}
\details{
This function can be used to seasonally and calendar adjust daily time series using multiplicative model.
}
\examples{
x = daily_sim(n=4)$original # series with length 4 years
res <- dsa(x, cval=7, model=c(3,1,0),fourier_number = 13, reg.create=NULL) 
}
\references{
Ollech, Daniel (2018). Seasonal adjustment of daily time series. Bundesbank Discussion Paper 41/2018.
}
\author{
Daniel Ollech
}
