% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/text_util_fun.R
\name{text_to_words}
\alias{text_to_words}
\title{Split string(s) of text \code{x} into words.}
\usage{
text_to_words(x)
}
\arguments{
\item{x}{A string of text (required), 
typically a character vector.}
}
\value{
A character vector (of words).
}
\description{
\code{text_to_words} splits a string of text \code{x} 
(consisting of one or more character strings) 
into a vector of its constituting words.
}
\details{
\code{text_to_words} removes all (standard) punctuation marks 
and empty spaces in the resulting text parts, 
before returning a vector of the remaining character symbols 
(as its words).

Internally, \code{text_to_words} uses \code{\link{strsplit}} to 
split strings at punctuation marks (\code{split = "[[:punct:]]"}) 
and blank spaces (\code{split = "( ){1,}"}).
}
\examples{
# Default: 
x <- c("Hello!", "This is a 1st sentence.", "This is the 2nd sentence.", "The end.")
text_to_words(x)

}
\seealso{
\code{\link{text_to_words}} for splitting a text into its words; 
\code{\link{text_to_sentences}} for splitting text into a vector of sentences;  
\code{\link{text_to_chars}} for splitting text into a vector of characters;  
\code{\link{count_words}} for counting the frequency of words; 
\code{\link{strsplit}} for splitting strings.

Other text objects and functions: 
\code{\link{Umlaut}},
\code{\link{capitalize}()},
\code{\link{caseflip}()},
\code{\link{cclass}},
\code{\link{chars_to_text}()},
\code{\link{collapse_chars}()},
\code{\link{count_chars_words}()},
\code{\link{count_chars}()},
\code{\link{count_words}()},
\code{\link{invert_rules}()},
\code{\link{l33t_rul35}},
\code{\link{map_text_chars}()},
\code{\link{map_text_coord}()},
\code{\link{map_text_regex}()},
\code{\link{metachar}},
\code{\link{read_ascii}()},
\code{\link{text_to_chars}()},
\code{\link{text_to_sentences}()},
\code{\link{transl33t}()},
\code{\link{words_to_text}()}
}
\concept{text objects and functions}
