% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ability_scores.R
\name{ability_scores}
\alias{ability_scores}
\title{Roll for All Ability Scores}
\usage{
ability_scores(method = "4d6", quiet = FALSE)
}
\arguments{
\item{method}{(character) string of "4d6", "3d6", or "1d20" ("d20" also accepted). Enter your preferred method of rolling for each ability score ("4d6" drops lowest before summing)}

\item{quiet}{(logical) whether to print warnings if the total score is very low or one ability score is very low}
}
\value{
(dataframe) two columns and six rows for ability score for each ability
}
\description{
Rolls for six ability scores using the desired method of rolling (4d6 drop lowest, 3d6, or 1d20). Doesn't assign abilities to facilitate player selection of which score should be each ability for a given character. Prints a warning if the total of all abilities is less than 70 or if any one ability is less than 8.
}
\examples{
# Roll ability scores using four d6 and dropping the lowest
ability_scores(method = "4d6")

# Roll using 3d6 and dropping nothing
ability_scores("3d6")

# Or if you're truly wild, just roll a d20 for each ability
ability_scores('d20')

}
