% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/d_labels.R
\name{diyar_label}
\alias{diyar_label}
\alias{encode}
\alias{decode}
\alias{encode.default}
\alias{encode.d_label}
\alias{decode.default}
\alias{decode.d_label}
\alias{rep.d_label}
\alias{[.d_label}
\alias{[[.d_label}
\title{Labelling in \code{diyar}}
\usage{
encode(x, ...)

decode(x, ...)

\method{encode}{default}(x, ...)

\method{encode}{d_label}(x, ...)

\method{decode}{default}(x, ...)

\method{decode}{d_label}(x, ...)

\method{rep}{d_label}(x, ...)

\method{[}{d_label}(x, i, ..., drop = TRUE)

\method{[[}{d_label}(x, i, ..., drop = TRUE)
}
\arguments{
\item{x}{\code{[d_label|atomic]}}

\item{...}{Other arguments.}

\item{i}{i}

\item{drop}{drop}
}
\value{
\code{d_label}; \code{atomic}
}
\description{
Encode and decode character and numeric values.
}
\details{
To minimise memory usage, most components of \code{\link[=pid-class]{pid}}, \code{\link[=epid-class]{epid}} and \code{\link[=pane-class]{pane}} are \code{integer} objects with labels.
\bold{\code{encode()}} and \bold{\code{decode()}} translates these codes and labels as required.
}
\examples{
cds <- encode(rep(LETTERS[1:5], 3))
cds

nms <- decode(cds)
nms
}
