% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/attribs.R
\name{imageAttributes}
\alias{imageAttributes}
\alias{imageAttributes<-}
\title{Extended image attributes}
\usage{
imageAttributes(x)

imageAttributes(x) <- value
}
\arguments{
\item{x}{An R object, generally an image object like those returned by
\code{\link{readDicom}}.}

\item{value}{A list of new image attributes to replace any existing ones.}
}
\value{
A list of image attributes, or a modified object with these changed.
These are essentially all attributes except those used for basic
\code{niftiImage} objects by the \code{RNifti} package.
}
\description{
These functions extract and replace medical image attributes that go beyond
the core metadata associated with the NIfTI-1 file format.
}
\details{
The DICOM format can encapsulate copious amounts of metadata about the scan
and the patient, which can be useful for more advanced or research-focussed
post-processing methods. Some of this information is extracted during the
DICOM-to-NIfTI conversion process and stored in additional named attributes;
the \code{imageAttributes} function returns a list of just these extended
attributes. The replacement form allows this metadata to be modified or
removed. These functions currently only act on objects inheriting from the
\code{niftiImage} class.
}
\note{
Attributes may include sensitive or identifiable information such as
a patient's name, sex, date of birth, etc., if this was included in the
original DICOM files. These functions make no attempt to identify or
anonymise this metadata, and so this must be handled by the user if
necessary.
}
\examples{
path <- system.file("extdata", "raw", package="divest")
images <- readDicom(path, interactive=FALSE)
imageAttributes(images[[1]])
}
\references{
More information about metadata captured by the BIDS format can
be found at \url{https://bids.neuroimaging.io} or in the paper cited
below.

K.J. Gorgolewski, T. Auer, V.D. Calhoun, et al. The brain imaging data
structure, a format for organizing and describing outputs of neuroimaging
experiments (2016). Scientific Data 3:160044. \doi{10.1038/sdata.2016.44}.
}
\author{
Jon Clayden \href{mailto:code@clayden.org}{code@clayden.org}
}
