% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HyperGeometric.R
\name{quantile.HyperGeometric}
\alias{quantile.HyperGeometric}
\title{Determine quantiles of a HyperGeometric distribution}
\usage{
\method{quantile}{HyperGeometric}(x, probs, ...)
}
\arguments{
\item{x}{A \code{HyperGeometric} object created by a call to \code{\link[=HyperGeometric]{HyperGeometric()}}.}

\item{probs}{A vector of probabilities.}

\item{...}{Unused. Unevaluated arguments will generate a warning to
catch mispellings or other possible errors.}
}
\value{
A vector of quantiles, one for each element of \code{probs}.
}
\description{
Determine quantiles of a HyperGeometric distribution
}
\examples{

set.seed(27)

X <- HyperGeometric(4, 5, 8)
X

random(X, 10)

pdf(X, 2)
log_pdf(X, 2)

cdf(X, 4)
quantile(X, 0.7)
}
\seealso{
Other HyperGeometric distribution: 
\code{\link{cdf.HyperGeometric}()},
\code{\link{pdf.HyperGeometric}()},
\code{\link{random.HyperGeometric}()}
}
\concept{HyperGeometric distribution}
