% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Bernoulli.R
\name{pdf.Bernoulli}
\alias{pdf.Bernoulli}
\alias{log_pdf.Bernoulli}
\title{Evaluate the probability mass function of a Bernoulli distribution}
\usage{
\method{pdf}{Bernoulli}(d, x, ...)

\method{log_pdf}{Bernoulli}(d, x, ...)
}
\arguments{
\item{d}{A \code{Bernoulli} object created by a call to \code{\link[=Bernoulli]{Bernoulli()}}.}

\item{x}{A vector of elements whose probabilities you would like to
determine given the distribution \code{d}.}

\item{...}{Unused. Unevaluated arguments will generate a warning to
catch mispellings or other possible errors.}
}
\value{
A vector of probabilities, one for each element of \code{x}.
}
\description{
Evaluate the probability mass function of a Bernoulli distribution
}
\examples{

set.seed(27)

X <- Bernoulli(0.7)
X

mean(X)
variance(X)
skewness(X)
kurtosis(X)

random(X, 10)
pdf(X, 1)
log_pdf(X, 1)
cdf(X, 0)
quantile(X, 0.7)

cdf(X, quantile(X, 0.7))
quantile(X, cdf(X, 0.7))

}
