% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Uniform.R
\name{Uniform}
\alias{Uniform}
\title{Create a Continuous Uniform distribution}
\usage{
Uniform(a = 0, b = 1)
}
\arguments{
\item{a}{The a parameter. \code{a} can be any value in the set of real
numbers. Defaults to \code{0}.}

\item{b}{The a parameter. \code{b} can be any value in the set of real
numbers. It should be strictly bigger than \code{a}, but if is not, the
order of the parameters is inverted. Defaults to \code{1}.}
}
\value{
A \code{Uniform} object.
}
\description{
A distribution with constant density on an interval. The
continuous analogue to the \code{\link[=Categorical]{Categorical()}} distribution.
}
\examples{

set.seed(27)

X <- Uniform(1, 2)
X

random(X, 10)

pdf(X, 0.7)
log_pdf(X, 0.7)

cdf(X, 0.7)
quantile(X, 0.7)

cdf(X, quantile(X, 0.7))
quantile(X, cdf(X, 0.7))

}
\seealso{
Other continuous distributions: 
\code{\link{Beta}()},
\code{\link{Cauchy}()},
\code{\link{ChiSquare}()},
\code{\link{Erlang}()},
\code{\link{Exponential}()},
\code{\link{FisherF}()},
\code{\link{Frechet}()},
\code{\link{GEV}()},
\code{\link{GP}()},
\code{\link{Gamma}()},
\code{\link{Gumbel}()},
\code{\link{LogNormal}()},
\code{\link{Logistic}()},
\code{\link{Normal}()},
\code{\link{RevWeibull}()},
\code{\link{StudentsT}()},
\code{\link{Tukey}()},
\code{\link{Weibull}()}
}
\concept{continuous distributions}
