% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist_inverse_gamma.R
\name{dist_inverse_gamma}
\alias{dist_inverse_gamma}
\title{The Inverse Gamma distribution}
\usage{
dist_inverse_gamma(shape, rate = 1/scale, scale)
}
\arguments{
\item{shape}{parameters. Must be strictly positive.}

\item{rate}{an alternative way to specify the scale.}

\item{scale}{parameters. Must be strictly positive.}
}
\description{
\lifecycle{stable}
}
\examples{
dist <- dist_inverse_gamma(shape = c(1,2,3,3), rate = c(1,1,1,2))
dist

\dontshow{if (requireNamespace("actuar", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
mean(dist)
variance(dist)
support(dist)
generate(dist, 10)

density(dist, 2)
density(dist, 2, log = TRUE)

cdf(dist, 4)

quantile(dist, 0.7)
\dontshow{\}) # examplesIf}
}
\seealso{
\link[actuar:InverseGamma]{actuar::InverseGamma}
}
