% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/subset.R
\docType{methods}
\name{subset}
\alias{subset}
\alias{[[,CA,ANY,missing-method}
\alias{[[,PCA,ANY,missing-method}
\title{Extract Parts of an Object}
\usage{
\S4method{[[}{CA,ANY,missing}(x, i)

\S4method{[[}{PCA,ANY,missing}(x, i)
}
\arguments{
\item{x}{An object from which to extract element(s) or in which to replace
element(s).}

\item{i}{A \code{\link{character}} string specifying elements to extract.
Any unambiguous substring can be given (see details).}
}
\value{
A \code{\link{list}}.
}
\description{
Operators acting on objects to extract parts.
}
\details{
If \code{i} is "\code{data}", returns a list with the following elements:
\describe{
\item{\code{data}}{A \code{\link{numeric}} matrix of raw data.}
\item{\code{mean}}{A \code{\link{numeric}} vector giving the variables means (\code{PCA}).}
\item{\code{sd}}{A \code{\link{numeric}} vector giving the variables standard deviations
(\code{PCA}).}
}

If \code{i} is "\code{rows}", returns a list with the following elements:
\describe{
\item{\code{coord}}{A \code{\link{numeric}} matrix of rows/individuals coordinates.}
\item{\code{cos2}}{A \code{\link{numeric}} matrix of rows/individuals squared cosine.}
\item{\code{masses}}{A \code{\link{numeric}} vector giving the rows masses/individual
weights.}
\item{\code{sup}}{A \code{\link{logical}} vector specifying whether a point is a
supplementary observation or not.}
}

If \code{i} is "\code{columns}", returns a list with the following elements:
\describe{
\item{\code{coord}}{A \code{\link{numeric}} matrix of columns/variables coordinates.}
\item{\code{cor}}{A \code{\link{numeric}} matrix of correlation between variables and
the dimensions (\code{PCA}).}
\item{\code{cos2}}{A \code{\link{numeric}} matrix of columns/variables squared cosine.}
\item{\code{masses}}{A \code{\link{numeric}} vector giving the columns masses/variable
weights.}
\item{\code{sup}}{A \code{\link{logical}} vector specifying whether a point is a
supplementary observation or not.}
}

If \code{i} is "\code{eigenvalues}", returns a \code{\link{numeric}} vector of eigenvalues.
}
\examples{
## Load data
data("iris")

## Compute principal components analysis
X <- pca(iris, scale = TRUE, sup_row = 8:10, sup_col = 1, sup_quali = "Species")

## Get results for the individuals
X[["rows"]]
}
\seealso{
Other mutators: 
\code{\link{dimnames}()}
}
\author{
N. Frerebeau
}
\concept{mutators}
