% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/plot.R
\docType{methods}
\name{plot}
\alias{plot}
\alias{plot,PCOA,missing-method}
\title{Plot Coordinates}
\usage{
\S4method{plot}{PCOA,missing}(
  x,
  ...,
  axes = c(1, 2),
  labels = FALSE,
  extra_quali = NULL,
  extra_quanti = NULL,
  color = NULL,
  fill = FALSE,
  symbol = FALSE,
  size = c(1, 6),
  xlim = NULL,
  ylim = NULL,
  main = NULL,
  sub = NULL,
  ann = graphics::par("ann"),
  frame.plot = TRUE,
  panel.first = NULL,
  panel.last = NULL
)
}
\arguments{
\item{x}{An \R object.}

\item{...}{Further \link[graphics:par]{graphical parameters}.}

\item{axes}{A length-two \code{\link{numeric}} vector giving the dimensions to be
plotted.}

\item{labels}{A \code{\link{logical}} scalar: should labels be drawn? Labeling a large
number of points can be computationally expensive and make the graph
difficult to read. A selection of points to label can be provided using a
\code{list} of two named elements, \code{filter} (a string specifying how to filter
the labels to be drawn) and \code{n} (an integer specifying the number of labels
to be drawn). See examples below.}

\item{extra_quali}{An optional vector of qualitative data for aesthetics
mapping.}

\item{extra_quanti}{An optional vector of quantitative data for aesthetics
mapping. If a single \code{\link{character}} string is passed, it must be one of
"\code{observation}", "\code{mass}", "\code{sum}", "\code{contribution}" or "\code{cos2}"
(see \code{\link[=augment]{augment()}}).}

\item{color}{The colors for lines and points (will be mapped to
\code{extra_quanti} or \code{extra_quali}; if both are set, the latter has priority).
Ignored if set to \code{FALSE}.}

\item{fill}{The background colors for points (will be mapped to
\code{extra_quanti} or \code{extra_quali}; if both are set, the latter has priority).
Ignored if set to \code{FALSE}.}

\item{symbol}{A vector of plotting characters or symbols (will be mapped to
\code{extra_quali}). This can either be a single character or an integer code for
one of a set of graphics symbols. If \code{symbol} is a named a named vector,
then the symbols will be associated with their name within \code{extra_quali}.
Ignored if set to \code{FALSE}.}

\item{size}{A length-two \code{\link{numeric}} vector giving range of possible sizes
(greater than 0; will be mapped to \code{extra_quanti}).
Ignored if set to \code{FALSE}.}

\item{xlim}{A length-two \code{\link{numeric}} vector giving the x limits of the plot.
The default value, \code{NULL}, indicates that the range of the
\link[=is.finite]{finite} values to be plotted should be used.}

\item{ylim}{A length-two \code{\link{numeric}} vector giving the y limits of the plot.
The default value, \code{NULL}, indicates that the range of the
\link[=is.finite]{finite} values to be plotted should be used.}

\item{main}{A \code{\link{character}} string giving a main title for the plot.}

\item{sub}{A \code{\link{character}} string giving a subtitle for the plot.}

\item{ann}{A \code{\link{logical}} scalar: should the default annotation (title and x
and y axis labels) appear on the plot?}

\item{frame.plot}{A \code{\link{logical}} scalar: should a box be drawn around the
plot?}

\item{panel.first}{An \code{expression} to be evaluated after the plot axes are
set up but before any plotting takes place. This can be useful for drawing
background grids.}

\item{panel.last}{An \code{expression} to be evaluated after plotting has taken
place but before the axes, title and box are added.}
}
\description{
Plot Coordinates
}
\seealso{
Other plot methods: 
\code{\link{biplot}()},
\code{\link{screeplot}()},
\code{\link{viz_contributions}()},
\code{\link{viz_individuals}()},
\code{\link{viz_variables}()},
\code{\link{viz_wrap}},
\code{\link{wrap}}
}
\author{
N. Frerebeau
}
\concept{plot methods}
