% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/carrier.R
\name{get_carrier}
\alias{get_carrier}
\title{Phone number carrier information}
\usage{
get_carrier(x, strict = FALSE, safe = FALSE,
  locale = getOption("dialr.locale"))
}
\arguments{
\item{x}{A \link{phone} vector.}

\item{strict}{Should invalid phone numbers be removed? If \code{TRUE}, invalid
phone numbers are replaced with \code{NA}.}

\item{safe}{If \code{TRUE}, gets the name of the carrier for a given phone
number only when it is 'safe' to display to users. A carrier name is
considered safe if the number is valid and for a region that doesn't
support mobile number portability. All other phone numbers return \code{""}.}

\item{locale}{The \href{https://docs.oracle.com/javase/8/docs/api/java/util/Locale.html}{Java locale}
used to retrieve localised results. The default is set in option
\code{dialr.locale}.}
}
\value{
A carrier name for each phone number for the given locale, or \code{""} if
the number is invalid.
}
\description{
Returns a carrier name for each phone number, in the language provided
in \code{locale}.
}
\details{
The carrier name is the one the number was originally allocated to, however
if the country supports mobile number portability the number might not belong
to the returned carrier anymore. If no mapping is found \code{""} is returned.
}
\section{libphonenumber reference}{


\code{get_geocode()}: \code{PhoneNumberToCarrierMapper.getNameForValidNumber()} by
default, or \code{PhoneNumberToCarrierMapper.getSafeDisplayName()} if \code{safe = TRUE}.
}

\examples{
x <- phone(c(0, 0123, "0412 345 678", "61412987654", "03 9123 4567", "+12015550123"), "AU")
get_carrier(x)
get_carrier(x, strict = TRUE)
get_carrier(x, safe = TRUE)
}
