% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-dgirtfit-plot.r
\docType{methods}
\name{dgirt_plot}
\alias{dgirt_plot}
\alias{dgirt_plot,dgo_fit-method}
\alias{dgirt_plot,data.frame-method}
\alias{plot,dgo_fit,missing-method}
\alias{plot_rhats}
\alias{plot_rhats,dgo_fit-method}
\title{Plot estimates and diagnostic statistics}
\usage{
dgirt_plot(x, ...)

\S4method{dgirt_plot}{dgo_fit}(x, y_fun = "median", y_min = "q_025",
  y_max = "q_975", pars = "theta_bar")

\S4method{dgirt_plot}{data.frame}(x, group_name, time_name, geo_name,
  y_fun = "median", y_min = "q_025", y_max = "q_975")

\S4method{plot}{dgo_fit,missing}(x, y, ...)

plot_rhats(x, ...)

\S4method{plot_rhats}{dgo_fit}(x, pars = "theta_bar", facet_vars = NULL,
  shape_var = NULL, color_var = NULL, x_var = NULL)
}
\arguments{
\item{x}{A \code{dgo_fit-class} object.}

\item{...}{Further arguments to \code{\link{dgirt_plot}}.}

\item{y_fun}{Summary function to be plotted as \code{y}.}

\item{y_min}{Summary function giving the \code{ymin} argument for a
\code{geom_pointrange} object.}

\item{y_max}{Summary function giving the \code{ymax} argument for a
\code{geom_pointrange} object.}

\item{pars}{Selected parameter.}

\item{group_name}{A discrete grouping variable that will be passed to the
\code{color} argument of \code{aes}.}

\item{time_name}{A time variable with numeric values that will be plotted on
the x axis.}

\item{geo_name}{A variable representing local areas that will be used in
faceting.}

\item{y}{Ignored.}

\item{facet_vars}{Optionally, one or more variables passed to \code{facet_wrap}}

\item{shape_var, color_var, x_var}{Optionally, a variable passed to the
\code{shape}, \code{color}, or \code{x} arguments of \code{aes_string},
respectively.}
}
\description{
\code{dgirt_plot} plots estimates from a dgo model. \code{plot_rhats} plots
split R-hats.
}
\examples{
\dontrun{
data(toy_dgirtfit)
dgirt_plot(toy_dgirtfit)
dgirt_plot(toy_dgirtfit, y_min = NULL, y_max = NULL)
p <- dgirt_plot(toy_dgirtfit)
p \%+\% ylab("posterior median")
}
\dontrun{
data(toy_dgirtfit)
ps <- poststratify(toy_dgirtfit, annual_state_race_targets, strata_names =
                   c("state", "year"), aggregated_names = "race3")
dgirt_plot(ps, group_name = NULL, time_name = "year", geo_name = "state")
}
\dontrun{
data(toy_dgirtfit)
plot(toy_dgirtfit)
}
\dontrun{
data(toy_dgirtfit)
plot_rhats(toy_dgirtfit)
plot_rhats(toy_dgirtfit, facet_vars = "race3") +
  scale_x_continuous(breaks = seq.int(2006, 2008))
}
}
