/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.graph.specifics;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.jgrapht.graph.AbstractBaseGraph;
import org.jgrapht.graph.EdgeSetFactory;
import org.jgrapht.graph.specifics.ArrayUnenforcedSetEdgeSetFactory;
import org.jgrapht.graph.specifics.Specifics;
import org.jgrapht.graph.specifics.UndirectedEdgeContainer;
import org.jgrapht.util.ArrayUnenforcedSet;

public class UndirectedSpecifics<V, E>
implements Specifics<V, E>,
Serializable {
    private static final long serialVersionUID = 6494588405178655873L;
    private static final String NOT_IN_UNDIRECTED_GRAPH = "no such operation in an undirected graph";
    protected AbstractBaseGraph<V, E> abstractBaseGraph;
    protected Map<V, UndirectedEdgeContainer<V, E>> vertexMapUndirected;
    protected EdgeSetFactory<V, E> edgeSetFactory;

    public UndirectedSpecifics(AbstractBaseGraph<V, E> abstractBaseGraph) {
        this(abstractBaseGraph, new LinkedHashMap(), new ArrayUnenforcedSetEdgeSetFactory());
    }

    public UndirectedSpecifics(AbstractBaseGraph<V, E> abstractBaseGraph, Map<V, UndirectedEdgeContainer<V, E>> vertexMap) {
        this(abstractBaseGraph, vertexMap, new ArrayUnenforcedSetEdgeSetFactory());
    }

    public UndirectedSpecifics(AbstractBaseGraph<V, E> abstractBaseGraph, Map<V, UndirectedEdgeContainer<V, E>> vertexMap, EdgeSetFactory<V, E> edgeSetFactory) {
        this.abstractBaseGraph = abstractBaseGraph;
        this.vertexMapUndirected = vertexMap;
        this.edgeSetFactory = edgeSetFactory;
    }

    @Override
    public void addVertex(V v) {
        this.vertexMapUndirected.put(v, null);
    }

    @Override
    public Set<V> getVertexSet() {
        return this.vertexMapUndirected.keySet();
    }

    @Override
    public Set<E> getAllEdges(V sourceVertex, V targetVertex) {
        ArrayUnenforcedSet edges = null;
        if (this.abstractBaseGraph.containsVertex(sourceVertex) && this.abstractBaseGraph.containsVertex(targetVertex)) {
            edges = new ArrayUnenforcedSet();
            for (Object e : this.getEdgeContainer(sourceVertex).vertexEdges) {
                boolean equal = this.isEqualsStraightOrInverted(sourceVertex, targetVertex, e);
                if (!equal) continue;
                edges.add(e);
            }
        }
        return edges;
    }

    @Override
    public E getEdge(V sourceVertex, V targetVertex) {
        if (this.abstractBaseGraph.containsVertex(sourceVertex) && this.abstractBaseGraph.containsVertex(targetVertex)) {
            for (Object e : this.getEdgeContainer(sourceVertex).vertexEdges) {
                boolean equal = this.isEqualsStraightOrInverted(sourceVertex, targetVertex, e);
                if (!equal) continue;
                return e;
            }
        }
        return null;
    }

    private boolean isEqualsStraightOrInverted(Object sourceVertex, Object targetVertex, E e) {
        boolean equalStraight = sourceVertex.equals(this.abstractBaseGraph.getEdgeSource(e)) && targetVertex.equals(this.abstractBaseGraph.getEdgeTarget(e));
        boolean equalInverted = sourceVertex.equals(this.abstractBaseGraph.getEdgeTarget(e)) && targetVertex.equals(this.abstractBaseGraph.getEdgeSource(e));
        return equalStraight || equalInverted;
    }

    @Override
    public void addEdgeToTouchingVertices(E e) {
        V source = this.abstractBaseGraph.getEdgeSource(e);
        V target = this.abstractBaseGraph.getEdgeTarget(e);
        this.getEdgeContainer(source).addEdge(e);
        if (!source.equals(target)) {
            this.getEdgeContainer(target).addEdge(e);
        }
    }

    @Override
    public int degreeOf(V vertex) {
        if (this.abstractBaseGraph.isAllowingLoops()) {
            int degree = 0;
            Set edges = this.getEdgeContainer(vertex).vertexEdges;
            for (Object e : edges) {
                if (this.abstractBaseGraph.getEdgeSource(e).equals(this.abstractBaseGraph.getEdgeTarget(e))) {
                    degree += 2;
                    continue;
                }
                ++degree;
            }
            return degree;
        }
        return this.getEdgeContainer(vertex).edgeCount();
    }

    @Override
    public Set<E> edgesOf(V vertex) {
        return this.getEdgeContainer(vertex).getUnmodifiableVertexEdges();
    }

    @Override
    public int inDegreeOf(V vertex) {
        throw new UnsupportedOperationException(NOT_IN_UNDIRECTED_GRAPH);
    }

    @Override
    public Set<E> incomingEdgesOf(V vertex) {
        throw new UnsupportedOperationException(NOT_IN_UNDIRECTED_GRAPH);
    }

    @Override
    public int outDegreeOf(V vertex) {
        throw new UnsupportedOperationException(NOT_IN_UNDIRECTED_GRAPH);
    }

    @Override
    public Set<E> outgoingEdgesOf(V vertex) {
        throw new UnsupportedOperationException(NOT_IN_UNDIRECTED_GRAPH);
    }

    @Override
    public void removeEdgeFromTouchingVertices(E e) {
        V source = this.abstractBaseGraph.getEdgeSource(e);
        V target = this.abstractBaseGraph.getEdgeTarget(e);
        this.getEdgeContainer(source).removeEdge(e);
        if (!source.equals(target)) {
            this.getEdgeContainer(target).removeEdge(e);
        }
    }

    protected UndirectedEdgeContainer<V, E> getEdgeContainer(V vertex) {
        UndirectedEdgeContainer<V, E> ec = this.vertexMapUndirected.get(vertex);
        if (ec == null) {
            ec = new UndirectedEdgeContainer<V, E>(this.edgeSetFactory, vertex);
            this.vertexMapUndirected.put((UndirectedEdgeContainer<V, E>)vertex, (UndirectedEdgeContainer<UndirectedEdgeContainer<V, E>, E>)ec);
        }
        return ec;
    }
}

