/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.alg.spanning;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import org.jgrapht.Graph;
import org.jgrapht.alg.interfaces.SpanningTreeAlgorithm;
import org.jgrapht.alg.util.UnionFind;

public class KruskalMinimumSpanningTree<V, E>
implements SpanningTreeAlgorithm<E> {
    private final Graph<V, E> graph;

    public KruskalMinimumSpanningTree(Graph<V, E> graph) {
        this.graph = Objects.requireNonNull(graph, "Graph cannot be null");
    }

    @Override
    public SpanningTreeAlgorithm.SpanningTree<E> getSpanningTree() {
        UnionFind<V> forest = new UnionFind<V>(this.graph.vertexSet());
        ArrayList<E> allEdges = new ArrayList<E>(this.graph.edgeSet());
        Collections.sort(allEdges, (edge1, edge2) -> Double.valueOf(this.graph.getEdgeWeight(edge1)).compareTo(this.graph.getEdgeWeight(edge2)));
        double spanningTreeCost = 0.0;
        HashSet<E> edgeList = new HashSet<E>();
        for (E edge : allEdges) {
            V source = this.graph.getEdgeSource(edge);
            V target = this.graph.getEdgeTarget(edge);
            if (forest.find(source).equals(forest.find(target))) continue;
            forest.union(source, target);
            edgeList.add(edge);
            spanningTreeCost += this.graph.getEdgeWeight(edge);
        }
        return new SpanningTreeAlgorithm.SpanningTreeImpl(edgeList, spanningTreeCost);
    }
}

