% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modelfuzzy_possibilistic.R
\name{modelfuzzy_possibilistic}
\alias{modelfuzzy_possibilistic}
\title{Possibilistic Fuzzy DEA model.}
\usage{
modelfuzzy_possibilistic(datadea,
                         dmu_eval = NULL,
                         poss_modelname = c("basic"),
                         h = 1,
                         ...)
}
\arguments{
\item{datadea}{The data, including DMUs, inputs and outputs.}

\item{dmu_eval}{A numeric vector containing which DMUs have to be evaluated.}

\item{poss_modelname}{a string containing the name of the model.}

\item{h}{A numeric vector with the h-levels (in [0,1]).}

\item{...}{\code{dmu_ref}, \code{orientation}, \code{rts} and other model parameters.}
}
\value{
An object of class \code{deadata_fuzzy}.
}
\description{
Solve the possibilistic fuzzy DEA model proposed by León et. al (2003).
}
\examples{
# Replication of results in Leon et. al (2003, p. 416)
data("Leon2003")
data_example <- read_data_fuzzy(Leon2003,
                                inputs.mL = 2, 
                                inputs.dL = 3, 
                                outputs.mL = 4, 
                                outputs.dL = 5)
result <- modelfuzzy_possibilistic(data_example, 
                                   h = seq(0, 1, by = 0.1), 
                                   orientation = "io", 
                                   rts = "vrs")
efficiencies(result)
 
}
\references{
Emrouznejad, A.; Tavana, M.; Hatami-Marbini, A. (2014). “The State of the Art in Fuzzy Data Envelopment Analysis”, in A. Emrouznejad and M. Tavana (eds.), Performance Measurement with Fuzzy Data Envelopment Analysis. Studies in Fuzziness and Soft Computing 309. Springer, Berlin. \url{https://doi.org/10.1007/978-3-642-41372-8_1}

Hatami-Marbini, A.; Emrouznejad, A.; Tavana, M. (2011). "A Taxonomy and Review of the Fuzzy Data Envelopment Analysis Literature: Two Decades in the Making", European Journal of Operational Research, 214, 457–472. \url{https://doi.org/10.1016/j.ejor.2011.02.001}

Léon, T.; Liern, V. Ruiz, J.; Sirvent, I. (2003). "A Possibilistic Programming Approach to the Assessment of Efficiency with DEA Models", Fuzzy Sets and Systems, 139, 407–419. \url{https://doi.org/10.1016/S0165-0114(02)00608-5}
}
\seealso{
\code{\link{model_basic}}, \code{\link{modelfuzzy_kaoliu}}, \code{\link{modelfuzzy_guotanaka}}
}
\author{
\strong{Vicente Coll-Serrano} (\email{vicente.coll@uv.es}).
\emph{Quantitative Methods for Measuring Culture (MC2). Applied Economics.}

\strong{Vicente Bolós} (\email{vicente.bolos@uv.es}).
\emph{Department of Business Mathematics}

\strong{Rafael Benítez} (\email{rafael.suarez@uv.es}).
\emph{Department of Business Mathematics}

University of Valencia (Spain)
}
