% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/int_unexp_records_set.R
\name{int_unexp_records_set}
\alias{int_unexp_records_set}
\title{Check for unexpected data record set}
\usage{
int_unexp_records_set(level = c("dataframe", "segment"), ...)
}
\arguments{
\item{level}{\link{character} a character vector indicating whether the assessment should be conducted at the study level (level = "dataframe") or at the segment level (level = "segment").}

\item{...}{Depending on \code{level}, passed to either
\link{util_int_unexp_records_set_segment} or
\link{util_int_unexp_records_set_dataframe}}
}
\value{
a \link{list}. Depending on \code{level}, see
\link{util_int_unexp_records_set_segment} or
\link{util_int_unexp_records_set_dataframe} for a description of the outputs.
}
\description{
This function tests that the identifiers match a provided record set. It is possible to
check for unexpected data record sets by study segments or to consider only selected
segments.

\link{Indicator}
}
\examples{
\dontrun{
study_data <- readRDS(system.file("extdata", "ship.RDS",
  package = "dataquieR"
))
meta_data <- readRDS(system.file("extdata", "ship_meta.RDS",
  package = "dataquieR"
))
md1_segment <- readRDS(system.file("extdata", "meta_data_segment.RDS",
  package = "dataquieR"
))
ids_segment <- readRDS(system.file("extdata", "meta_data_ids_segment.RDS",
  package = "dataquieR"
))

# TODO: update examples
int_unexp_records_set(
  level = "segment",
  identifier_name_list = c("INTERVIEW", "LABORATORY"),
  valid_id_table_list = ids_segment,
  meta_data_record_check = md1_segment[,
    c("STUDY_SEGMENT", "SEGMENT_RECORD_CHECK")],
  study_data = study_data,
  meta_data = meta_data,
  meta_data_level = md1_segment
)
}
}
